/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCecPlatformIplParms;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspLparAttributes;
import com.ibm.hsc.fsp.cmdhelpers.FspLparConfigVpd;
import com.ibm.hsc.fsp.cmdhelpers.FspLparMMReserveMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspLparMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspLparPerformance;
import com.ibm.hsc.fsp.cmdhelpers.FspLparProcessingInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspLparSrcEntry;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVioSlotStates;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVirtualOptiConnect;
import com.ibm.hsc.fsp.cmdhelpers.FspTaggedIosForOs400;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.fsp.cmdhelpers.SrcEntry;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Partition;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparInstUpdater {
    private static final String GET_CURRENT_LPAR_PROCESSING = "GET_CURRENT_LPAR_PROCESSING";
    private static final String GET_PENDING_LPAR_PROCESSING = "GET_PENDING_LPAR_PROCESSING";
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private String mLparName;
    private UnsignedInt16 mLparId;
    private int mLparIdIntValue;
    private FspCmdHelper mFspCmdHelper;
    private UnsignedInt8 mLparState;
    private FSPCmdMgr mFspCmdMgr;
    private boolean isMegaMouth = false;
    private static final int PARTITION_CHANGES_ALL = 65535;
    private static final int PARTITION_CHANGES_SLOT_DEFINITION = 1;
    private static final int PARTITION_CHANGES_CUR_PEND_PROCS_MEMORY = 2;
    private static final int PARTITION_CHANGES_RUNTIME_PROCS_MEMORY = 4;
    private static final int PARTITION_CHANGES_VIRTUAL_IO = 8;
    private static final int PARTITION_CHANGES_HYPERVISOR_IP_CONFIG = 16;
    private static final int PARTITION_CHANGES_TAGGED_IO = 32;

    public OmLparInstUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparName = this.mLparMgr.getLparName();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        this.mFspCmdHelper = this.mCecMgr.getCmdHelper();
        this.mFspCmdMgr = this.mCecMgr.getCmdMgr();
        int n = Integer.parseInt(this.mLparName.substring(0, this.mLparName.indexOf("*")));
        this.mLparId = new UnsignedInt16(n);
        this.mLparIdIntValue = n;
    }

    public boolean update() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        RObject rObject = (RObject)this.mLparObj.clone();
        System.out.println("[OM] update partition: " + this.mLparId);
        if (!this.mCecMgr.isHypervisorRunning()) {
            FspCecPlatformIplParms fspCecPlatformIplParms = this.mFspCmdHelper.getPlatformIplParameters("PRIMARY");
            int n = fspCecPlatformIplParms.getCurrCecLmbSize().intValue();
            int[] nArray = new int[]{16, 128, 256};
            if (n > 2 || n < 0) {
                System.out.println("Error LMB size from FSP: " + n);
                n = 0;
            }
            if (this.mCecMgr.setProperty(R50ComputerSystem.Index_LMBSize, (Object)new UnsignedInt16(nArray[n]))) {
                bl = true;
                System.out.println("[OM]LMBSize=" + nArray[n]);
            }
            return bl;
        }
        if (this.updatePartitionChanges(65535, false)) {
            bl = true;
        }
        if (this.updateVspChanges(false)) {
            bl = true;
        }
        return bl;
    }

    public boolean updatePartitionChanges(int n) throws RException, PIHscServerException, PIHscCmdMgrException {
        System.out.println("[OM] update partition changes: " + this.mLparName);
        return this.updatePartitionChanges(n, true);
    }

    private boolean updatePartitionChanges(int n, boolean bl) throws RException, PIHscServerException, PIHscCmdMgrException {
        RObject rObject = null;
        if (bl) {
            rObject = (RObject)this.mLparObj.clone();
        }
        this.mLparState = this.mFspCmdHelper.getLparSlotDefinitionState(this.mLparId);
        if (this.mLparState.intValue() == 65 || this.mLparState.intValue() == 66) {
            this.isMegaMouth = true;
        }
        boolean bl2 = false;
        if ((n & 1) != 0) {
            if (this.updateLparMiscProperties()) {
                bl2 = true;
            }
            if (this.updateLparConfigVpd()) {
                bl2 = true;
            }
            if (this.updateLparAttributes()) {
                bl2 = true;
            }
        }
        if ((n & 2) != 0) {
            if (this.updateLparProcessingResourcesCurrent()) {
                bl2 = true;
            }
            if (this.updateLparProcessingResourcesPending()) {
                bl2 = true;
            }
            if (this.updateLparCurrentPendingMemory()) {
                bl2 = true;
            }
        }
        if ((n & 4) != 0 || (n & 2) != 0) {
            if (this.updateLparProcessingResourcesRuntime()) {
                bl2 = true;
            }
            if (this.updateLparRuntimeMemory()) {
                bl2 = true;
            }
            if (this.updateLparCurrentPendingRuntimePerformance()) {
                bl2 = true;
            }
            if (this.isMegaMouth && this.updateLparMMReserveMemory()) {
                bl2 = true;
            }
        }
        if ((n & 8) != 0) {
            if (this.updateLparVirtualIoSlotStates()) {
                bl2 = true;
            }
            if (this.updateLparVirtualOptiConnect()) {
                bl2 = true;
            }
        }
        if ((n & 0x10) != 0) {
            System.out.println("PARTITION_CHANGES_HYPERVISOR_IP_CONFIG not supported yet!");
        }
        if ((n & 0x20) != 0 && this.updateTaggedIosForOs400()) {
            bl2 = true;
        }
        if (bl2 && bl) {
            HSCEventIndicationMgr.getInstance().sendIndication(4, this.mLparObj, rObject);
        }
        return bl2;
    }

    public boolean updateVspChanges() throws RException, PIHscServerException, PIHscCmdMgrException {
        System.out.println("[OM] update vsp changes: " + this.mLparName);
        return this.updateVspChanges(true);
    }

    public boolean updateVspSrcChange(boolean bl) {
        boolean bl2 = false;
        try {
            Object object;
            FspLparSrcEntry fspLparSrcEntry = this.mFspCmdHelper.getLPARCurrentSRC("getCurrentSRC", null, this.mLparId.toString());
            String string = "";
            if (fspLparSrcEntry != null && (object = fspLparSrcEntry.getSrcEntry()) != null && (string = ((SrcEntry)object).getAddData()) == null) {
                string = "";
            }
            object = null;
            if (bl) {
                object = (RObject)this.mLparObj.clone();
            }
            if (this.mLparObj.setProperty("OpPanelValue", (Object)string)) {
                bl2 = true;
                System.out.println("OpPanelValue = " + string);
                if (object != null) {
                    HSCEventIndicationMgr.getInstance().sendIndication(4, this.mLparObj, object);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl2;
    }

    private boolean updateVspChanges(boolean bl) throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl2 = false;
        RObject rObject = null;
        if (bl) {
            rObject = (RObject)this.mLparObj.clone();
        }
        if (this.updateSupportedVirtualPanelFunctions()) {
            bl2 = true;
        }
        if (this.updateLparVspAttributes()) {
            bl2 = true;
        }
        if (bl2 && bl) {
            HSCEventIndicationMgr.getInstance().sendIndication(4, this.mLparObj, rObject);
        }
        return bl2;
    }

    private boolean updateLparMiscProperties() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        String string = this.mFspCmdHelper.getLparUserDefName(this.mLparId);
        if (this.mLparState == null) {
            this.mLparState = this.mFspCmdHelper.getLparSlotDefinitionState(this.mLparId);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_DefinitionState, (Object)this.mLparState)) {
            bl = true;
            System.out.println("DefinitionState = " + this.mLparState);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Name, (Object)this.mLparName)) {
            bl = true;
            System.out.println("Name = " + this.mLparName);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CreationClassName, (Object)"IBMHSC_Partition")) {
            bl = true;
            System.out.println("Creation Class Name = IBMHSC_Partition");
        }
        if (this.mLparObj.setProperty(R50Partition.Index_UserDefinedName, (Object)string)) {
            bl = true;
            System.out.println("UserDefinedName = " + string);
        }
        return bl;
    }

    private boolean updateLparAttributes() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        FspLparAttributes fspLparAttributes = this.mFspCmdHelper.getLparAttributes(this.mLparId);
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array = fspLparAttributes.getPowerCtrlPartitions();
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            vector.add(unsignedInt16Array[i]);
        }
        if (vector.size() == 0) {
            vector = null;
        }
        if (this.mLparObj.setProperty(R50Partition.Index_HostingPartitions, vector)) {
            bl = true;
            System.out.println("HostingPartitions = " + vector);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_SharedPoolUtilizationAuthority, (Object)fspLparAttributes.getSharedPoolUtilAuth())) {
            bl = true;
            System.out.println("SharedPoolUtilizationAuthority = " + fspLparAttributes.getSharedPoolUtilAuth());
        }
        return bl;
    }

    private boolean updateLparConfigVpd() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        FspLparConfigVpd fspLparConfigVpd = this.mFspCmdHelper.getLparConfigVpd(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_LogicalSerialNum, (Object)fspLparConfigVpd.getLogicalSerialNum())) {
            bl = true;
            System.out.println("LogicalSerialNum = " + fspLparConfigVpd.getLogicalSerialNum());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsProduct, (Object)fspLparConfigVpd.getOsProduct())) {
            bl = true;
            System.out.println("OsProduct = " + fspLparConfigVpd.getOsProduct());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsVersion, (Object)fspLparConfigVpd.getOsVersion())) {
            bl = true;
            System.out.println("OsVersion = " + fspLparConfigVpd.getOsVersion());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsRelease, (Object)fspLparConfigVpd.getOsRelease())) {
            bl = true;
            System.out.println("OsRelease = " + fspLparConfigVpd.getOsRelease());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsModLevel, (Object)fspLparConfigVpd.getOsModLevel())) {
            bl = true;
            System.out.println("OsModLevel = " + fspLparConfigVpd.getOsModLevel());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsDriver, (Object)fspLparConfigVpd.getOsDriver())) {
            bl = true;
            System.out.println("OsDriver = " + fspLparConfigVpd.getOsDriver());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OsFixLevel, (Object)fspLparConfigVpd.getOsFixLevel())) {
            bl = true;
            System.out.println("OsFixLevel = " + fspLparConfigVpd.getOsFixLevel());
        }
        return bl;
    }

    private boolean updateLparProcessingResourcesCurrent() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        String string = GET_CURRENT_LPAR_PROCESSING;
        FspLparProcessingInfo fspLparProcessingInfo = this.mFspCmdHelper.getCurrentLparProcessingInfo(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_CurProcMode, (Object)fspLparProcessingInfo.getProcType())) {
            bl = true;
            System.out.println("CurProcMode = " + fspLparProcessingInfo.getProcType());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurSharingMode, (Object)fspLparProcessingInfo.getSharingMode())) {
            bl = true;
            System.out.println("CurSharingMode = " + fspLparProcessingInfo.getSharingMode());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurUncappedWeight, (Object)fspLparProcessingInfo.getUncappedWeight())) {
            bl = true;
            System.out.println("CurUncappedWeight = " + fspLparProcessingInfo.getUncappedWeight());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMinProcs, (Object)fspLparProcessingInfo.getMinProcs())) {
            bl = true;
            System.out.println("CurMinProcs = " + fspLparProcessingInfo.getMinProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurAllocProcs, (Object)fspLparProcessingInfo.getAllocProcs())) {
            bl = true;
            System.out.println("CurAllocProcs = " + fspLparProcessingInfo.getAllocProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMaxProcs, (Object)fspLparProcessingInfo.getMaxProcs())) {
            bl = true;
            System.out.println("CurMaxProcs = " + fspLparProcessingInfo.getMaxProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMinProcUnits, (Object)fspLparProcessingInfo.getMinProcUnits())) {
            bl = true;
            System.out.println("CurMinProcUnits = " + fspLparProcessingInfo.getMinProcUnits());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurAllocProcUnits, (Object)fspLparProcessingInfo.getAllocProcUnits())) {
            bl = true;
            System.out.println("CurAllocProcUnits = " + fspLparProcessingInfo.getAllocProcUnits());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMaxProcUnits, (Object)fspLparProcessingInfo.getMaxProcUnits())) {
            bl = true;
            System.out.println("CurMaxProcUnits = " + fspLparProcessingInfo.getMaxProcUnits());
        }
        return bl;
    }

    private boolean updateLparProcessingResourcesPending() throws RException, PIHscServerException, PIHscCmdMgrException {
        FspLparProcessingInfo fspLparProcessingInfo = this.mFspCmdHelper.getPendingLparProcessingInfo(this.mLparId);
        return this.updatePendingLparProcessingInfo(fspLparProcessingInfo);
    }

    public boolean updatePendingLparProcessingInfo(FspLparProcessingInfo fspLparProcessingInfo) throws RException {
        boolean bl = false;
        if (this.mLparObj.setProperty(R50Partition.Index_PendProcMode, (Object)fspLparProcessingInfo.getProcType())) {
            bl = true;
            System.out.println("PendProcMode = " + fspLparProcessingInfo.getProcType());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendSharingMode, (Object)fspLparProcessingInfo.getSharingMode())) {
            bl = true;
            System.out.println("PendSharingMode = " + fspLparProcessingInfo.getSharingMode());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMinProcs, (Object)fspLparProcessingInfo.getMinProcs())) {
            bl = true;
            System.out.println("PendMinProcs = " + fspLparProcessingInfo.getMinProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendAllocProcs, (Object)fspLparProcessingInfo.getAllocProcs())) {
            bl = true;
            System.out.println("PendAllocProcs = " + fspLparProcessingInfo.getAllocProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMaxProcs, (Object)fspLparProcessingInfo.getMaxProcs())) {
            bl = true;
            System.out.println("PendMaxProcs = " + fspLparProcessingInfo.getMaxProcs());
        }
        if (fspLparProcessingInfo.getProcType().intValue() != 255) {
            if (this.mLparObj.setProperty(R50Partition.Index_PendUncappedWeight, (Object)fspLparProcessingInfo.getUncappedWeight())) {
                bl = true;
                System.out.println("PendUncappedWeight = " + fspLparProcessingInfo.getUncappedWeight());
            }
            if (this.mLparObj.setProperty(R50Partition.Index_PendMinProcUnits, (Object)fspLparProcessingInfo.getMinProcUnits())) {
                bl = true;
                System.out.println("PendMinProcUnits = " + fspLparProcessingInfo.getMinProcUnits());
            }
            if (this.mLparObj.setProperty(R50Partition.Index_PendAllocProcUnits, (Object)fspLparProcessingInfo.getAllocProcUnits())) {
                bl = true;
                System.out.println("PendAllocProcUnits = " + fspLparProcessingInfo.getAllocProcUnits());
            }
            if (this.mLparObj.setProperty(R50Partition.Index_PendMaxProcUnits, (Object)fspLparProcessingInfo.getMaxProcUnits())) {
                bl = true;
                System.out.println("PendMaxProcUnits = " + fspLparProcessingInfo.getMaxProcUnits());
            }
        }
        return bl;
    }

    private boolean updateLparProcessingResourcesRuntime() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        FspLparProcessingInfo fspLparProcessingInfo = this.mFspCmdHelper.getRuntimeLparProcessingInfo(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeProcMode, (Object)fspLparProcessingInfo.getRuntimeProcMode())) {
            bl = true;
            System.out.println("RuntimeProcMode = " + fspLparProcessingInfo.getRuntimeProcMode());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeUncappedWeight, (Object)fspLparProcessingInfo.getRuntimeUncappedWeight())) {
            bl = true;
            System.out.println("RuntimeUncappedWeight = " + fspLparProcessingInfo.getRuntimeUncappedWeight());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeProcs, (Object)fspLparProcessingInfo.getRuntimeProcs())) {
            bl = true;
            System.out.println("RuntimeProcs = " + fspLparProcessingInfo.getRuntimeProcs());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeProcUnits, (Object)fspLparProcessingInfo.getRuntimeProcUnits())) {
            bl = true;
            System.out.println("RuntimeProcUnits = " + fspLparProcessingInfo.getRuntimeProcUnits());
        }
        return bl;
    }

    private boolean updateLparCurrentPendingMemory() throws RException, PIHscServerException, PIHscCmdMgrException {
        RObject rObject = this.mCecMgr.getObject();
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty(R50ComputerSystem.Index_LMBSize);
        int n = unsignedInt16.intValue();
        boolean bl = false;
        FspLparMemory fspLparMemory = this.mFspCmdHelper.getCurrAndPendLparMem(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_CurMinMem, (Object)new UnsignedInt32(fspLparMemory.getCurMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("CurMinMem = " + fspLparMemory.getCurMinMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurAllocMem, (Object)new UnsignedInt32(fspLparMemory.getCurAllocMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("CurAllocMem = " + fspLparMemory.getCurAllocMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMaxMem, (Object)new UnsignedInt32(fspLparMemory.getCurMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("CurMaxMem = " + fspLparMemory.getCurMaxMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMinMem, (Object)new UnsignedInt32(fspLparMemory.getPendMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("PendMinMem = " + fspLparMemory.getPendMinMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendAllocMem, (Object)new UnsignedInt32(fspLparMemory.getPendAllocMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("PendAllocMem = " + fspLparMemory.getPendAllocMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMaxMem, (Object)new UnsignedInt32(fspLparMemory.getPendMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("PendMaxMem = " + fspLparMemory.getPendMaxMem());
        }
        return bl;
    }

    private boolean updateLparRuntimeMemory() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        RObject rObject = this.mCecMgr.getObject();
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty(R50ComputerSystem.Index_LMBSize);
        int n = unsignedInt16.intValue();
        FspLparMemory fspLparMemory = this.mFspCmdHelper.getRuntimeLparMem(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeMem, (Object)new UnsignedInt32(fspLparMemory.getRuntimeMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("RuntimeMem = " + fspLparMemory.getRuntimeMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeMinMem, (Object)new UnsignedInt32(fspLparMemory.getRuntimeMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("RuntimeMinMem = " + fspLparMemory.getRuntimeMinMem());
        }
        return bl;
    }

    private boolean updateLparMMReserveMemory() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        RObject rObject = this.mCecMgr.getObject();
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty(R50ComputerSystem.Index_LMBSize);
        int n = unsignedInt16.intValue();
        FspLparMMReserveMemory fspLparMMReserveMemory = this.mFspCmdHelper.getLparMMReserveMemory(this.mLparId);
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1CurAllocMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1CurMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1CurMem = " + fspLparMMReserveMemory.getR1CurMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1CurMaxMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1CurMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1CurMaxMem = " + fspLparMMReserveMemory.getR1CurMaxMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1CurMinMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1CurMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1CurMinMem = " + fspLparMMReserveMemory.getR1CurMinMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1PendAllocMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1PendMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1PendMem = " + fspLparMMReserveMemory.getR1PendMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1PendMaxMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1PendMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1PendMaxMem = " + fspLparMMReserveMemory.getR1PendMaxMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve1PendMinMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR1PendMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve1PendMinMem = " + fspLparMMReserveMemory.getR1PendMinMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2CurAllocMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2CurMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2CurMem = " + fspLparMMReserveMemory.getR2CurMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2CurMaxMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2CurMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2CurMaxMem = " + fspLparMMReserveMemory.getR2CurMaxMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2CurMinMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2CurMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2CurMinMem = " + fspLparMMReserveMemory.getR2CurMinMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2PendAllocMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2PendMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2PendMem = " + fspLparMMReserveMemory.getR2PendMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2PendMaxMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2PendMaxMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2PendMaxMem = " + fspLparMMReserveMemory.getR2PendMaxMem());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Reserve2PendMinMem, (Object)new UnsignedInt32(fspLparMMReserveMemory.getR2PendMinMem().longValue() * (long)n))) {
            bl = true;
            System.out.println("Reserve2PendMinMem = " + fspLparMMReserveMemory.getR2PendMinMem());
        }
        return bl;
    }

    private boolean updateLparCurrentPendingRuntimePerformance() throws RException, PIHscServerException, PIHscCmdMgrException {
        FspLparPerformance fspLparPerformance;
        boolean bl = false;
        if (this.mLparState == null) {
            this.mLparState = this.mFspCmdHelper.getLparSlotDefinitionState(this.mLparId);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMinInteractivePerf, (Object)(fspLparPerformance = (this.mLparState.intValue() & 0x80) != 0 ? this.mFspCmdHelper.getLparPerformance(this.mLparId) : new FspLparPerformance()).getCurMinInteractivePerf())) {
            bl = true;
            System.out.println("CurMinInteractivePerf = " + fspLparPerformance.getCurMinInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurAllocInteractivePerf, (Object)fspLparPerformance.getCurAllocInteractivePerf())) {
            bl = true;
            System.out.println("CurAllocInteractivePerf = " + fspLparPerformance.getCurAllocInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_CurMaxInteractivePerf, (Object)fspLparPerformance.getCurMaxInteractivePerf())) {
            bl = true;
            System.out.println("CurMaxInteractivePerf = " + fspLparPerformance.getCurMaxInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMinInteractivePerf, (Object)fspLparPerformance.getPendMinInteractivePerf())) {
            bl = true;
            System.out.println("PendMinInteractivePerf = " + fspLparPerformance.getPendMinInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendAllocInteractivePerf, (Object)fspLparPerformance.getPendAllocInteractivePerf())) {
            bl = true;
            System.out.println("PendAllocInteractivePerf = " + fspLparPerformance.getPendAllocInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMaxInteractivePerf, (Object)fspLparPerformance.getPendMaxInteractivePerf())) {
            bl = true;
            System.out.println("PendMaxInteractivePerf = " + fspLparPerformance.getPendMaxInteractivePerf());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_RuntimeInteractivePerf, (Object)fspLparPerformance.getRuntimeInteractivePerf())) {
            bl = true;
            System.out.println("RuntimeInteractivePerf = " + fspLparPerformance.getRuntimeInteractivePerf());
        }
        return bl;
    }

    private boolean updateLparVirtualOptiConnect() throws RException, PIHscServerException, PIHscCmdMgrException {
        FspLparVirtualOptiConnect fspLparVirtualOptiConnect;
        boolean bl = false;
        if (this.mLparState == null) {
            this.mLparState = this.mFspCmdHelper.getLparSlotDefinitionState(this.mLparId);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_VirtualOptiConnect, (Object)(fspLparVirtualOptiConnect = (this.mLparState.intValue() & 0x80) != 0 ? this.mCecMgr.getCmdHelper().getLparVirtualOptiConnect(this.mLparId) : new FspLparVirtualOptiConnect()).getVirtualOptiConnect())) {
            bl = true;
            System.out.println("VirtualOptiConnect = " + fspLparVirtualOptiConnect.getVirtualOptiConnect());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_HSLOptiConnect, (Object)fspLparVirtualOptiConnect.getHslOptiConnect())) {
            bl = true;
            System.out.println("HSLOptiConnect = " + fspLparVirtualOptiConnect.getHslOptiConnect());
        }
        return bl;
    }

    private boolean updateLparVirtualIoSlotStates() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        FspLparVioSlotStates fspLparVioSlotStates = this.mCecMgr.getCmdHelper().getFspLparVioSlotStates(this.mLparId, unsignedInt16, unsignedInt16);
        if (this.mLparObj.setProperty(R50Partition.Index_CurMaxVirtualIOSlots, (Object)fspLparVioSlotStates.getCurMaxVirtualIOSlots())) {
            bl = true;
            System.out.println("CurMaxVirtualIOSlots = " + fspLparVioSlotStates.getCurMaxVirtualIOSlots());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PendMaxVirtualIOSlots, (Object)fspLparVioSlotStates.getPendMaxVirtualIOSlots())) {
            bl = true;
            System.out.println("PendMaxVirtualIOSlots = " + fspLparVioSlotStates.getPendMaxVirtualIOSlots());
        }
        return bl;
    }

    private boolean updateLparVspAttributes() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        boolean bl2 = false;
        FspVspAttr fspVspAttr = null;
        try {
            fspVspAttr = this.mFspCmdHelper.getLparVspAttributes(this.mLparId);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (fspVspAttr == null) {
            fspVspAttr = new FspVspAttr(new UnsignedInt8(1), new UnsignedInt8(8), new UnsignedInt8(0), new UnsignedInt8(0), new UnsignedInt8(0), new UnsignedInt8(4));
        }
        if (this.mLparObj.setProperty(R50Partition.Index_BootMode, (Object)fspVspAttr.getBootMode())) {
            bl = true;
            System.out.println("BootMode = " + fspVspAttr.getBootMode());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_IPLSource, (Object)fspVspAttr.getIplSource())) {
            bl = true;
            System.out.println("IPLSource = " + fspVspAttr.getIplSource());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PowerOnWithHypervisor, (Object)fspVspAttr.getPowerOnWithHypervisor())) {
            bl = true;
            System.out.println("PowerOnWithHypervisor = " + fspVspAttr.getPowerOnWithHypervisor());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_VirtualServiceAttLed, (Object)fspVspAttr.getVirtualServiceAttLed())) {
            bl = true;
            System.out.println("VirtualServiceAttLed = " + fspVspAttr.getVirtualServiceAttLed());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_PartitionState, (Object)fspVspAttr.getPowerState())) {
            bl = true;
            System.out.println("PartitionState = " + fspVspAttr.getPowerState());
        }
        if (this.mLparObj.setProperty(R50Partition.Index_Keylock, (Object)fspVspAttr.getKeylock())) {
            bl = true;
            System.out.println("Keylock = " + fspVspAttr.getKeylock());
        }
        if (this.updateVspSrcChange(false)) {
            bl = true;
        }
        return bl;
    }

    private boolean updateTaggedIosForOs400() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        if (this.mLparState == null) {
            this.mLparState = this.mFspCmdHelper.getLparSlotDefinitionState(this.mLparId);
        }
        if (this.mLparState.intValue() != 130 && this.mLparState.intValue() != 129) {
            return bl;
        }
        long l = 65535L;
        FspTaggedIosForOs400 fspTaggedIosForOs400 = this.mCecMgr.getCmdHelper().getTaggedIosForOs400(this.mLparId);
        Hashtable hashtable = this.mCecMgr.getPhyIODrcIndexTable();
        System.out.println("physicalIoDrcIndexTable = " + hashtable);
        Vector<Boolean> vector = new Vector<Boolean>();
        vector.setSize(6);
        UnsignedInt32 unsignedInt32 = fspTaggedIosForOs400.getLoadSrcDrcIndex();
        long l2 = unsignedInt32.longValue();
        if (l2 == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 0);
        } else {
            vector.setElementAt(new Boolean(true), 0);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_LoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("LoadSourceDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getAltLoadSrcDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 1);
        } else {
            vector.setElementAt(new Boolean(true), 1);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_AltLoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("AltLoadSourceDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getConsoleDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 2);
        } else {
            vector.setElementAt(new Boolean(true), 2);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_ConsoleDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("ConsoleDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getAltConsoleDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 3);
        } else {
            vector.setElementAt(new Boolean(true), 3);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_AltConsoleDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("AltConsoleDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getEcsDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 4);
        } else {
            vector.setElementAt(new Boolean(true), 4);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_ECSDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("ECSDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getOldAltLoadSrcDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 5);
        } else {
            vector.setElementAt(new Boolean(true), 5);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OldAltLoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("OldAltLoadSourceDRCIndex = " + unsignedInt32);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_TaggedIOInfo, vector)) {
            bl = true;
            System.out.println("taggedIOInfo = " + vector);
        }
        return bl;
    }

    public boolean updateTaggedIO(FspTaggedIosForOs400 fspTaggedIosForOs400) throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        long l = 65535L;
        Hashtable hashtable = this.mCecMgr.getPhyIODrcIndexTable();
        System.out.println("physicalIoDrcIndexTable = " + hashtable);
        Vector<Boolean> vector = new Vector<Boolean>();
        vector.setSize(6);
        UnsignedInt32 unsignedInt32 = fspTaggedIosForOs400.getLoadSrcDrcIndex();
        long l2 = unsignedInt32.longValue();
        if (l2 == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 0);
        } else {
            vector.setElementAt(new Boolean(true), 0);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_LoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("LoadSourceDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getAltLoadSrcDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 1);
        } else {
            vector.setElementAt(new Boolean(true), 1);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_AltLoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("AltLoadSourceDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getConsoleDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 2);
        } else {
            vector.setElementAt(new Boolean(true), 2);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_ConsoleDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("ConsoleDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getAltConsoleDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 3);
        } else {
            vector.setElementAt(new Boolean(true), 3);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_AltConsoleDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("AltConsoleDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getEcsDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 4);
        } else {
            vector.setElementAt(new Boolean(true), 4);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_ECSDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("ECSDRCIndex = " + unsignedInt32);
        }
        if ((l2 = (unsignedInt32 = fspTaggedIosForOs400.getOldAltLoadSrcDrcIndex()).longValue()) == 0L || hashtable.containsKey(unsignedInt32)) {
            vector.setElementAt(new Boolean(false), 5);
        } else {
            vector.setElementAt(new Boolean(true), 5);
            unsignedInt32 = new UnsignedInt32(l2 & l);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_OldAltLoadSourceDRCIndex, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("OldAltLoadSourceDRCIndex = " + unsignedInt32);
        }
        if (this.mLparObj.setProperty(R50Partition.Index_TaggedIOInfo, vector)) {
            bl = true;
            System.out.println("taggedIOInfo = " + vector);
        }
        return bl;
    }

    private boolean updateSupportedVirtualPanelFunctions() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        byte[] byArray = this.mFspCmdHelper.getSupportedVirtualPanelFunc(this.mLparId);
        UnsignedInt8[] unsignedInt8Array = null;
        if (byArray != null) {
            unsignedInt8Array = new UnsignedInt8[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                unsignedInt8Array[i] = new UnsignedInt8((short)byArray[i]);
            }
        }
        if (this.mLparObj.setProperty(R50Partition.Index_VirtualPanelFunctions, (Object)unsignedInt8Array)) {
            bl = true;
            System.out.println("supported virtual panel functions = " + ByteUtilities.toHexString(byArray));
        }
        return bl;
    }
}

